/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSemaphoreImpDrv98.h,v 1.2 1999/09/17 04:20:50 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSemaphoreImpDrv98_h	// [
#define Included_CSemaphoreImpDrv98_h

#include "pgpClassesConfig.h"
#include "CSemaphoreImp.h"

_PGP_BEGIN

// Class CSemaphoreImpDrv98

class CSemaphoreImpDrv98 : public CSemaphoreImp
{
	friend class CPFLImpFactoryDrv98;

private:
	CSemaphoreImpDrv98();

public:
	~CSemaphoreImpDrv98();

	PGPUInt32	Wait(PGPInt32 msTimeout);
	void		Signal(PGPUInt32 count);

private:
	SEMHANDLE	mSemaphore;
};


// Class CSemaphoreImpDrv98 member functions

inline 
CSemaphoreImpDrv98::CSemaphoreImpDrv98()
{
	if (IsNull(mSemaphore = Create_Semaphore(0)))
		Status().pgpErr = kPGPError_SyncObjOpFailed;
}

inline 
CSemaphoreImpDrv98::~CSemaphoreImpDrv98()
{
	if (IsntNull(mSemaphore))
	{
		Destroy_Semaphore(mSemaphore);
		mSemaphore = NULL;
	}
}

inline 
PGPUInt32 
CSemaphoreImpDrv98::Wait(PGPInt32 msTimeout)
{
	pgpAssert(msTimeout == CMutex::InfiniteTimeout);
	Wait_Semaphore(mSemaphore, BLOCK_SVC_INTS | BLOCK_THREAD_IDLE);

	return 0;
}

inline 
void 
CSemaphoreImpDrv98::Signal(PGPUInt32 count)
{
	pgpAssert(count == 1);
	Signal_Semaphore(mSemaphore);
}

_PGP_END

#endif	// ] Included_CSemaphoreImpDrv98_h
